# 인터럽트 (Interrupt)

인터럽트란 CPU가 프로그램을 실행하고 있을 때, 입출력 하드웨어 등의 장치 또는 예외 상황의 처리가 필요한 경우에 CPU에게 알려 처리할 수 있도록 하는 것이다.  

CPU가 어떤 프로그램을 순차적으로 수행하는 중에 외부로부터 인터럽트 요구가 들어오면, CPU는 원래 프로그램의 수행을 중단하고 인터럽트를 먼저 처리한다. 인터럽트 처리가 끝나면 원래의 프로그램들로 복귀하여 수행을 계속한다.  

즉, CPU가 특정 기능을 수행하는 도중 급하게 다른 일을 처리하고자 할 때 사용한다.  

인터럽트는 크게 **하드웨어 인터럽트** 와 **소프트웨어 인터럽트**로 나뉜다. </br>

<br>

## 인터럽트 종류

### 하드웨어 인터럽트
CPU가 아닌 다른 하드웨어 장치가 CPU에게 어떤 사실을 알려주거나 CPU 서비스를 요청해야 할 경우 발생시킨다.  

- **전원 이상 인터럽트 (Power fail Interrupt)** : 정전, 전원이 이상 등의 경우에 발생한다.
- **기계 착오 인터럽트 (Machine Check Interrupt)** : CPU등의 기능적인 동작 오류가 생긴 경우에 발생한다.
- **외부 신호 인터럽트 (External Interrupt)** : 타이머 인터럽트(자원이 할당된 시간이 다 끝난 경우), 키보드 인터럽트(Control+Alt+Delete), 외부 장치 인터럽트
- **입출력 인터럽트 (I/O Interrupt)** : 입출력 장치가 데이터 전송을 요구하거나 다음 동작이 수행되어야 할 경우, 입출력 데이터에 이상 등의 경우에 발생한다.

### 소프트웨어 인터럽트 
주로 프로그램 실행 중에 발생한다.
- **프로그램 검사 인터럽트 (Program Check Interrupt)** : 0으로 나눈 경우, Overflow/Underflow 등의 경우에 발생한다.
- **SVC (Supervisor Call)** : 사용자가 프로그램을 실행한 경우, 복잡한 입출력 처리를 요구한 경우 발생한다.

<br>

## 인터럽트 우선순위
1. 전원 이상
2. 기계 착오
3. 외부 신호
4. 입출력 신호
5. 명령어 잘못
6. 프로그램 검사
7. SVC

<br>

## 인터럽트 동작 순서
1. 인터럽트 요청
  - 외부 이벤트나 조건에 의해 인터럽트가 발생한다.
2. 프로그램 실행 중단
  - 현재 실행 중인 프로그램이 일시 중단된다.
  - 이 시점에서 CPU는 현재 수행중인 명령을 완료하고 다음 명령은 수행하지 않는다.
3. 현재 실행중인 프로그램 상태 보관
  - 중단된 프로그램의 레지스터 상태를 저장한다. 이 정보는 나중에 해당 프로그램을 계속 할 때 필요하다.
  - `인터럽트 벡터(=인터럽트 번호)`를 읽어 `인터럽트 서비스 루틴 (ISR)` 주소값을 얻는다.
  - 인터럽트 서비스 루틴(ISR) 주소로 점프하여 인터럽트 서비스 루틴(ISR)을 실행한다. 이때, 현재 프로그램 카운터 값(PC)\*은 CPU 내부에 저장된다. 이를 `대피`라고 한다.
4. 인터럽트 서비스 루틴(ISR) 처리
  - 인터럽트 서비스 루틴(ISR)에서 실질적인 인터럽트 작업을 수행한다.
  - 이 단계에서 우선순위가 더 높은 인터럽트가 발생하면, 해당 인터럽트 처리를 먼저 재귀적으로 수행한다.
5. 상태 복구
  - 인터럽트 서비스 루틴(ISR) 작업이 완료되면, `대피`된 레지스터 상태 정보를 복원하여 중단된 프로그램을 계속한다.
  - 인터럽트 서비스 루틴(ISR)의 끝에 도달하면 IRET(Interrupt Retrun)\* 명령어를 사용하여 인터럽트가 해제되고, 이전 위치로 복귀한다. 이때, 대피된 PC 값이 사용되어 이전 실행 위치로 돌아간다.

_\*프로그램 카운터 값: 인터럽트 처리가 끝난 후 원래 위치로 복귀하기 위한 정보_  
_\*IRET 명렁어: 이전 task로 돌아가는 어셈블리 명령어_  

<br>

### 인터럽트 벡터 테이블
- 여러 개의 인터럽트에 대해 해당 인터럽트가 발생시 처리해야 할 인터럽트 서비스 루틴(ISR)의 주소를 저장하고 있는 테이블이다.
- 보통의 CPU들은 인터럽트 벡터 테이블을 가지고 있다.

### 인터럽트 서비스 루틴 (ISR)
- **인터럽트 핸들러**라고도 한다.  
- 인터럽트가 발생하면 각 인터럽트에 대응하여 특정 기능을 수행한다.

<br>

----

## Referance
- https://doh-an.tistory.com/31
- https://velog.io/@adam2/%EC%9D%B8%ED%84%B0%EB%9F%BD%ED%8A%B8
- https://velog.io/@hyun0310woo/7.-%EC%9A%B4%EC%98%81%EC%B2%B4%EC%A0%9C-%EC%9D%B8%ED%84%B0%EB%9F%BD%ED%8A%B8%EC%97%90-%EB%8C%80%ED%95%B4%EC%84%9C  
- https://velog.io/@wngkdroqkf441/CS-%EC%9A%B4%EC%98%81%EC%B2%B4%EC%A0%9C-%EC%9D%B8%ED%84%B0%EB%9F%BD%ED%8A%B8%EB%9E%80